Define CONFIG = 0x3f50



'program GCA186
'railroad crossing controller for two directions

'program option":
'program = 0  idle task
'_         1  LEDS START FLASHING FOR 1.5 SECS AND SOUND IS SWItched on after time out program 2
'_         2  BARRIERS going down, wen down program 3
'_         3  waiting for counting down to zero, when zero program 4
'_         4  barriers going up, when up > program 5
'_         5  relay off, flashing off, waiting for last sensor to count tot zero, then program = 0



CMCON = 7
TRISA = %11111111
TRISB = %00000000
PORTB = 255
PORTA = 255
AllDigital

Symbol hall_a = RA6
Symbol hall_b = RA7
Symbol hall_c = RA0
Symbol hall_d = RA1
Symbol servo_1 = RB5
Symbol servo_2 = RB4
Symbol rel = RB1
Symbol flash_1 = RB3
Symbol flash_2 = RB2
Symbol program_run = RB0

Dim flashtime As Byte
Dim flashdelay As Byte
Dim servo_value As Word
Const max_servo = 1400
Const min_servo = 400
Dim direction As Byte
Dim old_hall_a As Bit
Dim old_hall_b As Bit
Dim old_hall_c As Bit
Dim old_hall_d As Bit
Dim count_enter As Byte
Dim count_exit As Byte
Dim program As Byte
Dim end_reached As Bit
Dim dummy As Byte

servo_1 = 1
servo_2 = 1
servo_value = max_servo  'start in barrier up position
program = 0
old_hall_a = 0
old_hall_b = 0
old_hall_c = 0
old_hall_d = 0
count_exit = 0
count_enter = 0
flash_1 = 1
flash_2 = 1
flashdelay = 0
flashtime = 0
WaitMs 1000
main:
	For dummy = 1 To 15
		Gosub check_sensors
		WaitMs 1
	Next dummy
	program_run = 0
	If count_exit > 0 Then
		program_run = 1
	Endif
	Select Case program
	Case 0  'idle task
		count_enter = 0
		count_exit = 0
		end_reached = 1  'barriers are up
		Call flashes(0)
		direction = 0  'direction 1: first sensor =a  >>  direction =2 : first sensor = d
	Case 1  'activate flashing leds and soundrelay
		Call flashes(1)
		If flashtime > 12 Then  'enough flashing? start program 2
			program = 2
		Endif

	Case 2  'barriers down
		Call barrier_down()
		Call flashes(1)
		If end_reached = 0 Then
			program = 3
		Endif
	
	Case 3  'waiting for counting down count_enter
		Call flashes(1)
		If count_enter = 0 Then
			program = 4
		Endif
	Case 4  'barriers going up
		Call barrier_up()
		Call flashes(1)
		If end_reached = 1 Then
			program = 5
		Endif
	Case 5  'waiting for count down count_exit
		Call flashes(1)
		If count_exit = 0 Then
			program = 0
			Call flashes(0)
			flashtime = 0
			flashdelay = 0
			WaitMs 3000
		Endif
	Case Else
	EndSelect
		
	
Goto main
End                                               
Proc flashes(onoff As Bit)
	If onoff = 1 Then
		If flashdelay < 20 Then
			flashdelay = flashdelay + 1
		Else
			flashdelay = 0
			flash_2 = flash_1
			flash_1 = Not flash_2
			flashtime = flashtime + 1
		Endif
		rel = 0  'sound on
	Else
		flash_1 = 0  'leds off
		flash_2 = 0
		flashtime = 0
		flashdelay = 0
		rel = 1  'sound off
	Endif
End Proc                                          

check_sensors:
	Select Case direction
	Case 0  'program = also still 0!
		If hall_a = 0 Then
			If old_hall_a = 0 Then
				program = 1
				direction = 1
				count_enter = 1
				count_exit = 1
				old_hall_a = 1  'avoid the same been seen more than once in ome pass
			Endif
		Else
			old_hall_a = 0
		Endif
		If hall_d = 0 Then
			If old_hall_d = 0 Then
				program = 1
				direction = 2  'approach from other side
				count_enter = 1
				count_exit = 1
				old_hall_d = 1  'avoid the same been seen more than once in ome pass
			Endif
		Else
			old_hall_d = 0
		Endif

	Case 1  'forward from a to d
		If hall_a = 0 Then
			If old_hall_a = 0 Then
				count_enter = count_enter + 1
				count_exit = count_exit + 1
				old_hall_a = 1  'avoid the same been seen more than once in ome pass
			Endif
		Else
			old_hall_a = 0
		Endif
		If hall_c = 0 Then
			If old_hall_c = 0 Then
				If count_enter > 0 Then
					count_enter = count_enter - 1
					old_hall_c = 1  'avoid the same been seen more than once in ome pass
				Endif
			Endif
		Else
			old_hall_c = 0
		Endif
		If hall_d = 0 Then
			If old_hall_d = 0 Then
				If count_exit > 0 Then
					count_exit = count_exit - 1
					old_hall_d = 1  'avoid the same been seen more than once in ome pass
				Endif
			Endif
		Else
			old_hall_d = 0
		Endif
	Case Else  'reverse from d to a
		If hall_d = 0 Then
			If old_hall_d = 0 Then
				count_enter = count_enter + 1
				count_exit = count_exit + 1
				old_hall_d = 1  'avoid the same been seen more than once in ome pass
			Endif
		Else
			old_hall_d = 0
		Endif
		If hall_b = 0 Then
			If old_hall_b = 0 Then
				If count_enter > 0 Then
					count_enter = count_enter - 1
					old_hall_b = 1
				Endif
			Endif
		Else
			old_hall_b = 0
		Endif
		If hall_a = 0 Then
			If old_hall_a = 0 Then
				If count_exit > 0 Then
					count_exit = count_exit - 1
					old_hall_a = 1
				Endif
			Endif
		Else
			old_hall_a = 0
		Endif
	EndSelect
	
Return                                            

Proc barrier_up()
		If servo_value < max_servo Then
			servo_value = servo_value + 3
			Call set_servo()
		Else
			end_reached = 1
			servo_1 = 1
			servo_2 = 1
			Exit
		Endif
End Proc                                          

Proc barrier_down()
		If servo_value > min_servo Then
			servo_value = servo_value - 3
			Call set_servo()
		Else
			end_reached = 0
			servo_1 = 1
			servo_2 = 1
			Exit
		Endif
End Proc                                          

Proc set_servo()
	servo_1 = 1
	WaitUs servo_value
	servo_1 = 0
	servo_2 = 1
	WaitUs servo_value
	servo_2 = 0
End Proc                                          

